%This program is used to compute the ATS for independent cases by using the proposed method of Han and Tsung (2006).
%u0,s0 are the mean function and variance function estimated from IC data.
%u,s are the speicified mean function and variance function.
%h is the control limit
%m out of n is the sampling rate

function [ats,count]=ATS_D_adap_rf(u0,s0,u,s,h,m,n)
L=length(u0);
lambda=0.1;
ATS0=100;
for i=1:ceil(L/n)
    A=randperm(n);
    B(((i-1)*m+1):((i-1)*m+m))=(i-1)*n+sort(A(1:m));
end
% B(1)=1;
B(ceil(L/n)*m+1)=L+1;
T=B(1);
count=1;
x=normrnd(u(T),s(T));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Cn=max(0,abs((x-u0(T))/s0(T))*((x-u0(T))/s0(T)-abs((x-u0(T))/s0(T))/2));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
while (Cn<=h && T<=L)
    T=B(count+1);
if T>=L+1
    ats=T;
    break
else
x=normrnd(u(T),s(T));
count=count+1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Cn=max(0,Cn+abs((x-u0(T))/s0(T))*((x-u0(T))/s0(T)-abs((x-u0(T))/s0(T))/2));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end
end
if T>=L+1
    ats=T;
else
ats=T-B(1);
end
